/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tasklet;

import com.ibm.hwmca.fw.tasklet.ClientInformation;
import com.ibm.hwmca.fw.tasklet.TaskletClientExitInterface;
import com.ibm.hwmca.fw.tasklet.TaskletConnection;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletProxy;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.tasklet.xport.TaskletManager;
import com.ibm.hwmca.fw.util.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class Tasklet {
    private static final String TRACE_MASKT = "XTSKSTTT";
    private static final String TRACE_MASKF = "XTSKSTTF";
    private static final String TRACE_MASKD = "XTSKSTTD";
    private static int nextTaskletId = 0;
    protected TaskletManager manager = null;
    protected int traceId = 0;
    protected int taskletId = 0;
    protected ClientInformation clientInformation = new ClientInformation();
    protected boolean taskletTerminating = false;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Object redirectData = null;
    private TaskletProxy proxy = null;

    public void abnormalTerminate() {
        Trace.trace(TRACE_MASKF, "[Tasklet:" + this.traceId + "] abnormalTerminate() entry.");
        this.manager.terminate();
    }

    public TaskletConnection accept(String name) {
        return this.manager.accept(name);
    }

    public final void setProxy(TaskletProxy proxy) {
        Trace.trace(TRACE_MASKF, "[Tasklet:" + this.traceId + "] setProxy()");
        this.proxy = proxy;
    }

    public final void clearProxy() {
        Trace.trace(TRACE_MASKF, "[Tasklet:" + this.traceId + "] clearProxy()");
        this.proxy = null;
    }

    public final void performService(TaskletRequest taskletRequest, TaskletResponse taskletResponse) throws TaskletException {
        if (this.proxy == null) {
            this.service(taskletRequest, taskletResponse);
        } else {
            Trace.trace(TRACE_MASKF, "[Tasklet:" + this.traceId + "] performService() proxy detected");
            this.proxy.service(taskletRequest, taskletResponse);
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Trace.trace(TRACE_MASKF, "[Tasklet:" + this.traceId + "] addPropertyChangeListener(" + propertyName + "," + listener + ")");
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Trace.trace(TRACE_MASKF, "[Tasklet:" + this.traceId + "] addPropertyChangeListener(" + listener + ")");
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Trace.trace(TRACE_MASKF, "[Tasklet:" + this.traceId + "] removePropertyChangeListener(" + propertyName + "," + listener + ")");
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Trace.trace(TRACE_MASKF, "[Tasklet:" + this.traceId + "] removePropertyChangeListener(" + listener + ")");
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public final int getTaskletId() {
        return this.taskletId;
    }

    public abstract void init(Object var1) throws TaskletException;

    public abstract void service(TaskletRequest var1, TaskletResponse var2) throws TaskletException;

    public abstract void logException(Throwable var1);

    public void setTerminating(boolean value) {
        this.taskletTerminating = value;
    }

    public void destroy() {
        Trace.trace(TRACE_MASKF, "[Tasklet:" + this.traceId + "] destroy()");
    }

    public final ClientInformation getClientInformation() {
        return this.clientInformation;
    }

    public final String getUserid() {
        return this.clientInformation.getUserid();
    }

    public final Object getRedirectData() {
        return this.redirectData;
    }

    public final Object invokeExitOnClient(TaskletClientExitInterface exitObject) throws TaskletException {
        return this.manager.invokeExitOnClient(exitObject);
    }

    public void setRedirectData(Object redirectData) {
        Trace.trace(TRACE_MASKF, "[Tasklet:" + this.traceId + "] setRedirectData('" + redirectData + "')");
        this.redirectData = redirectData;
    }

    public final void setTaskletManager(TaskletManager manager) {
        this.manager = manager;
    }

    public final void setTaskletId(int taskletId) {
        this.taskletId = taskletId;
    }

    public final void setTraceId(int traceId) {
        this.traceId = traceId;
    }
}

